/*	Copyright (C) 2018-2024 Martin Guy <martinwguy@gmail.com>
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation, either version 3 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * a_cache.h - include file for clients of a_cache.c
 */

#ifndef A_CACHE_H

#include "a_file.h"	/* for af_format_t */

extern frames_t read_cached_audio(audio_file_t *af, char *data,
				  af_format_t format, int channels,
				  frames_t start, frames_t frames_to_read);
extern void reposition_audio_cache(void);
extern void dump_audio_cache(void);
extern void print_audio_cache_stats(void);

#define A_CACHE_H 1
#endif
